

	/****************************************************************
	*								*
	*	serial PROM down loader version 0.1			*	
	*		[C] feb 1985 aed, inc.				*
	*	programmer:	mark krueger mse			*
	*								*
	 ***************************************************************/

/*
	description:

	sends object file in m.out format ( form wa or mac ) to serial
	port /dev/tty01 or to std output if not /dev/console. Code
	segmented to size of PROM. Null padded with 1's to make speedy
	burn.

*/



#include <stdio.h>
#include <sgtty.h>
#include <ctype.h>

#define STDOUT	1		/* stdout filedes */
#define TTYFLG	040		/* sg_flags for port */
#define	MWORD	011223		/* magic word for input file */
#define	SECTS	8		/* max number of program sections */
#define	WSIZE	2		/* word size in bytes */
#define OPSIZE	8		/* op code size in bits */
#define	OPORT	"/dev/tty01"	/* output port for aed terminal */
#define CRLF	"\r\n"		/* car ret line feed pair for raw mode io */
#define PAD	0x00ff		/* padding character */
#define	SPACE	' '		/* space character */
#define	STX	'\002'		/* start transmission */
#define ETX	'\003'		/* end trans */


main(argc,argv)

int argc;
char *argv[];

{
	register unsigned i, j, num;
	extern unsigned psize;
	static unsigned add = 0;
	static unsigned bytes = 0;
	unsigned stadd = 0;
	register char *com;
	FILE *fopen(), *freopen(), *fin;
	static unsigned *buf[ 3 + 3*SECTS ];
	struct sect {
		unsigned size;
		unsigned add;
		unsigned attrib;
	};
	struct sect psect[SECTS];
	struct sgttyb ttys;


/*	
 *	check arguments and try to open objfile
 */

	if ( argc != 2 )
		{
		fprintf(stderr,"usage: prmbrn objfile [ >port ]\n");
		exit(1);
		}	

	if ( (fin = fopen( argv[1], "r" )) == NULL )
		{
		fprintf(stderr, "prmbrn: can't open %s\n", argv[1]);
		exit(1);
		}


/*
 *	check output port if stdout defined use it if not use OPORT
 */

	if ( strcmp((com = ttyname(STDOUT)),"/dev/console") == 0 )
		{
		if (freopen(OPORT,"a",stdout) == NULL)
			{
			fprintf(stderr, "prmbrn: can not open %s\n", OPORT);
			exit(1);
			}
		}

/*
 *	set up interface
 */

	if ( gtty(STDOUT, &ttys) == 0 )
		{
		ttys.sg_flags = TTYFLG;
		stty(STDOUT, &ttys);
		}

/*
 * 	read and check headers 
 */

	i = 0;
	if ( fread(buf, WSIZE, (3 + 3*SECTS), fin) == 0 )
		{
		fprintf(stderr, "prmbrn: input error %s\n", argv[1]);
		exit(1);
		}
	if ( buf[i++] != MWORD )
		{
		fprintf(stderr, "prmbrn: %s not in m.out format\n",argv[1]);
		exit(1);
		}
	if ( buf[i++] != OPSIZE )
		{
		fprintf(stderr, "prmbrn: %s not bytes\n", argv[1]);
		exit(1);
		}

	i++;	/* skip attrib word */
	j = 0;
	while ( j < SECTS )
		{
		psect[j].size = buf[i++];
		psect[j].add = buf[i++];	  
		psect[j++].attrib = buf[i++];
		}

/*
 *	find out promtype
 */

	fprintf(stderr,"prom type?\n");
	while ( psize == 0)
		{
		com = gets();
		if ( strcmp(com,"2708") == 0 )
			psize = 0x400;
		else if ( strcmp(com,"2716") == 0 )
			psize = 0x800;
		else if ( strcmp(com,"2732") == 0 )
			psize = 0x1000;
		else if ( strcmp(com,"2764") == 0 )
			psize = 0x2000;
		else
			fprintf(stderr,"types: 2708, 2716, 2732, 2764\n");
		}


	fprintf(stderr,"set prom burner to load, hit <cr> when ready.");
	while (getchar() != '\n');
	stx();
	  

/*
 *  	load all sections
 */

	for ( j = 0; j < SECTS; j++)
		{
		if (psect[j].size == 0)
			continue;

/*
 *	set up address positioning
 */

		if (psect[j].add != 0)
			{
			stadd = psect[j].add;
			bytes = align(add, stadd, bytes);
			}			

/*
 *	write data section to prom(s)
 */
		add = stadd;
		for ( i = 0; i < psect[j].size; i++)
			{
			if ( bytes == psize )
			  {
			  bytes = 0;
			  next();
			  }
			if ( fread(buf,WSIZE,1,fin) == 0 ) 
			  {
 			  fprintf(stderr,"prmbrn: out of data %s\n",argv[1]);
			  exit(1);
			  }
			send(buf[0]);
			add++;
			bytes++;
			}
		}

/*
 *	pad rest of prom with nulls
 */

	pad( (psize - bytes) ); 
	etx();
	fprintf(stderr,"prmbrn: done\n");
	exit(0);

	}



next()

/*
 *	ask for next prom
 */

{
	etx();
	fprintf(stderr,"end of prom; program part, hit <cr> when done.");
 	while (getchar() != '\n');
	fprintf(stderr,"insert new prom, set burner for load, hit <cr>.");
	while (getchar() != '\n');
	stx();
}

pad(byte)

unsigned byte;

/* 
 *	send bytes pad characters to stdout
 */

{

	register unsigned i;
	static unsigned pad = PAD;
	extern unsigned psize;

	if ( byte == 0 || byte == psize)	/*    ignore if 0 or all */
	 	return;
	for ( i = 0; i < byte; i++ )
		send(pad);
	return;
}

align(lstadr, adr, p_used)

unsigned lstadr;
unsigned adr;
unsigned p_used;

/*
 *	align data to prom size
 */

{	
	static unsigned b;
	register unsigned p_left;
	extern unsigned psize;

/*
 *	check if origin is lower than last address
 */
	if ( adr < lstadr )
		{
		fprintf( stderr,"prmbrn: address error\n");
		exit(1);
		}

/*
 *	check if done with last prom
 */

	if ( p_used == psize)
		{
		next();
		p_used = 0;
		}

/*
 *	skip any wholely unused proms
 */

	b = adr - lstadr;
	if ( p_used == 0 )
		while ( b >= psize && b != 0 )
			b -= psize;

/*
 *	pad rest of current prom if unused
 */

	if ( b > ( p_left = (psize - p_used) ) )
		{
		pad(p_left);
		b -= p_left;
		next();
		p_used = 0;

		/* skip any wholely unused proms */

		while ( b >= psize && b != 0)
			b -= psize;		
		}		

/*
 *	pad beginning of new prom up to start address
 */

	pad(b);
	p_used += b;
	return(p_used);
}		

send(dat)

unsigned dat;

/*
 *	send data in hex ascii - space format
 */


{	
	register int i;
	register char c;

	i = ( dat >> 4 )  & 0xf;
	i += 0x30;
	if ( i > 0x39 )
		i += 7;
	c = i;
	putchar(c);
	i = dat & 0xf;
	i += 0x30;
	if ( i > 0x39 )
		i += 7;
	c = i;
 	putchar(c);
	c = SPACE;
	putchar(c);

	return;
}

etx()

/*
 *	signal end of transmission
 */

{
	register char c;
	
	c = ETX;
	putchar(c);
	c = 'E';
	printf("dddddddddoneee!!!!");
	return;

}	

stx()

/*
 *	signal start of transmission
 */

{
	register char c;

	c = STX;
	putchar(c);
	printf("$A0000,");	
	return;

}




unsigned psize = 0;	/* size of prom */
